-- FUNCTION: public.ufd_est_prod_tbl_desc_pos_pbm(integer, integer, integer)

-- DROP FUNCTION public.ufd_est_prod_tbl_desc_pos_pbm(integer, integer, integer);

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_pos_pbm(
	integer,
	integer,
	integer,
	integer)
    RETURNS double precision
    LANGUAGE 'plpgsql'

    COST 100
    VOLATILE 
AS $BODY$ --<<inicio do corpo da funcao

-- function: select * from ufd_est_prod_tbl_desc_pos_pbm(1, 18, 13492,0)
-- function: select * from ufd_est_prod_tbl_desc_pos_pbm(1, 18, 13492)

/*  
 
 int_cd_emp          				  --- codigo da empresa  
 int_cd_filial       				  --- codigo da filial  
 int_cd_prod         				  --- codigo do produto  
 int_usa_desconto_propz_ident         --- utiliza desconto propz 

*/ 

--declara as variaveis usadas na funcao
declare

---------------------------------------------------------
----declara as variaveis que estao no cabecalho da funcao
---------------------------------------------------------
in_cd_emp              alias for $1;
in_cd_filial           alias for $2; 
in_cd_prod             alias for $3;
int_usa_desconto_propz_ident ALIAS FOR $4;

var_perc_desc          double precision;
---------------------------------------------------------
---fim
---------------------------------------------------------
begin --inicio dos blocos da funcao
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela temporaria de retorno
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table temp_tab_desc_prod_pos_pbm
		(	
			cd_tbl_desc 		integer,
			tp_desc 			integer,
			perc_desc			double precision,
			tp_nivel			integer,
			dt_ini              timestamp without time zone
		);
		exception when others then
		truncate table temp_tab_desc_prod_pos_pbm; -- trunca a tabela se ela ja existir na sessao.
	end;
	
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela que recebera as tbls vigentes
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_tab_ativa_pos_pbm
		(	
			cd_emp 		integer,    
			cd_tbl_desc integer,    
			tp_desc 	integer
		);
		exception when others then
		truncate table rs_tab_ativa_pos_pbm; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela de arvore mercadologica do produto
	-------------------------------------------------------------------------------------------------------------------------------
	
	begin
		create temporary table rs_est_prod_arv_merc_pos_pbm
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		exception when others then
		truncate table rs_est_prod_arv_merc_pos_pbm; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	

	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------fim da criacao das tbls temporarias-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------

		-------------------------------------------------------------------------------------------------------------------------------
		--buscando arvore merc. do produto
		-------------------------------------------------------------------------------------------------------------------------------	
		insert into rs_est_prod_arv_merc_pos_pbm		
			select 
				arv.cd_emp					,
				arv.cd_prod					,
				arv.cd_arv_merc_categ		,
				arv.cd_arv_merc_linha		,
				arv.cd_mc					,
				arv.cd_arv_merc_familia		,												
				p.cd_fabric 
			from 	est_prod_est_arv_mercadologica arv inner join est_prod p on
					arv.cd_emp		= p.cd_emp
					and arv.cd_prod = p.cd_prod
			where   	arv.cd_emp = in_cd_emp
				and 	arv.cd_prod = in_cd_prod;

		--raise notice 'cd_arv_merc_linha %', (select cd_arv_merc_linha from rs_est_prod_arv_merc limit 1);

			insert into rs_tab_ativa_pos_pbm    
				select  a.cd_emp,    
						a.cd_tbl_desc,    
						a.cd_tp_desconto
				from	est_prod_tbl_desc a inner join 
				        est_prod_tbl_desc_prc_filial fil on    
							a.cd_emp = fil.cd_emp and    
							a.cd_tbl_desc = fil.cd_tbl_desc 
				where	in_cd_emp = a.cd_emp and     
                        in_cd_filial = fil.cd_filial and		
						current_date between a.dt_ini and a.dt_fim and
						1 = a.sts_tbl_desc and    
						27 = a.cd_tp_desconto
						and	(
					      ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in(0,1))) OR 
					      ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz =0))
					    );
						
		if exists (select 1 from rs_est_prod_arv_merc_pos_pbm) then
			if exists (select 1 from rs_tab_ativa_pos_pbm) then
				-------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 1 - produtos    
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_pos_pbm     
					  select    
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,      
							b.perc_desc as perc_desc,      
							1 as tp_nivel,
							a.dt_ini    
					  from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_prod b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_tab_ativa_pos_pbm on    
								b.cd_emp = rs_tab_ativa_pos_pbm.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc     
							inner join rs_est_prod_arv_merc_pos_pbm arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_prod = arv.cd_prod           
					  where     
								in_cd_filial = fil.cd_filial;
								
				-------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 2 - familias    
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_pos_pbm     
					select   
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,    
							b.perc_desc as perc_desc,    
							2 as tp_nivel,
							a.dt_ini    
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_arv_merc_familia b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc_pos_pbm arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
							inner join rs_tab_ativa_pos_pbm on    
								a.cd_emp = rs_tab_ativa_pos_pbm.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					where     
							in_cd_filial = fil.cd_filial;
							
				-------------------------------------------------------------------------------------------------------------------------------        
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 3 - marcas    
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_pos_pbm     
					select
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,    
							b.perc_desc as perc_desc,     
							3 as tp_nivel,
							a.dt_ini    
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_mc b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc_pos_pbm arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_mc = arv.cd_mc    
							inner join rs_tab_ativa_pos_pbm on    
								a.cd_emp = rs_tab_ativa_pos_pbm.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					where     
							in_cd_filial = fil.cd_filial;
							
				-------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 4 - fabricantes    
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_pos_pbm     
					select   
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,      
							b.perc_desc as perc_desc,     
							4 as tp_nivel,
							a.dt_ini     
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_prod_fabric b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc_pos_pbm arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_fabric = arv.cd_fabric     
							inner join rs_tab_ativa_pos_pbm on    
								b.cd_emp = rs_tab_ativa_pos_pbm.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					where     
							in_cd_filial = fil.cd_filial;
							
				------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 5 - categorias         
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_pos_pbm     
					select   
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,    
							b.perc_desc as perc_desc,    
							5 as tp_nivel,
							a.dt_ini  
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_arv_merc_categoria b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc_pos_pbm arv on    
								b.cd_emp = arv.cd_emp and    
								b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
							inner join rs_tab_ativa_pos_pbm on    
								a.cd_emp = rs_tab_ativa_pos_pbm.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					where     
							in_cd_filial = fil.cd_filial;
							
				-------------------------------------------------------------------------------------------------------------------------------    
				--consultando as tbls de desconto para verificar se ha algum desconto no nivel 6 - linhas
				-------------------------------------------------------------------------------------------------------------------------------    
				insert into temp_tab_desc_prod_pos_pbm     
					select   
							a.cd_tbl_desc as cd_tbl_desc,    
							a.cd_tp_desconto as tp_desc,      
							b.perc_desc as perc_desc,    
							6 as tp_nivel,
							a.dt_ini 
					from est_prod_tbl_desc a    
							inner join est_prod_tbl_desc_est_arv_merc_linha b on    
								a.cd_emp = b.cd_emp and    
								a.cd_tbl_desc = b.cd_tbl_desc    
							inner join est_prod_tbl_desc_prc_filial fil on    
								b.cd_emp = fil.cd_emp and    
								b.cd_tbl_desc = fil.cd_tbl_desc    
							inner join rs_est_prod_arv_merc_pos_pbm arv on    
								b.cd_emp = arv.cd_emp and       
								b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
							inner join rs_tab_ativa_pos_pbm on    
								a.cd_emp = rs_tab_ativa_pos_pbm.cd_emp and    
								b.cd_tbl_desc = rs_tab_ativa_pos_pbm.cd_tbl_desc        
					where     
							in_cd_filial = fil.cd_filial;
				
				
			end if;	--if exists (select 1 from rs_tab_ativa_pos_pbm) then	
		end if; --if exists (select 1 from rs_est_prod_arv_merc) then
	 
	
	 
	-------------------------------------------------------------------------------------------------------------------------------
	-- retornando desconto limite (resultado da funcao)
	-------------------------------------------------------------------------------------------------------------------------------



		if exists (select 1 from temp_tab_desc_prod_pos_pbm) then

			
			select perc_desc into var_perc_desc
					  from temp_tab_desc_prod_pos_pbm 
					 order by dt_ini desc, tp_nivel asc, perc_desc desc limit 1;
		else

			
			var_perc_desc =   coalesce((select 
										coalesce(cast(valor as double precision), 0) 
									  from 
										prc_emp_config 
									  where 
										cd_emp = in_cd_emp and 
										cd_chave ilike 'desconto_pos_pbm') , 0);

		end if;

		return var_perc_desc / 100.;
	
end; --fim dos blocos da funcao
$BODY$;

ALTER FUNCTION public.ufd_est_prod_tbl_desc_pos_pbm(integer, integer, integer, integer)
    OWNER TO postgres;
